#! /usr/bin/perl

use strict;
use warnings;
use Digest::SHA qw(hmac_sha256_base64);

my $SECRET_KEY="<REPLACE WITH SECRET KEY>";

sub sign {
	my $data_to_sign = &build_data_to_sign( @_ );
	my $signed_data=&hmac_sha256_base64( $data_to_sign, $SECRET_KEY )."=";
	$signed_data.='=' if length( $signed_data ) < 44;
	return $signed_data;			
}

sub build_data_to_sign {
	my %payment_form_data = %{ $_[0] };
	my @signed_field_names = @{ $_[1] };
	my @data_to_sign = ();
	
	foreach (@signed_field_names) {
		push( @data_to_sign, "$_=$payment_form_data{$_}");						
	}
	return join(",", @data_to_sign);
}
