#! /usr/bin/perl

use strict;
use warnings;
use CGI qw/:standard/;
require 'security.pl';

my $page=CGI->new;

print   $page->header,
	$page->start_html( -title=>'Smart Checkout - Receipt Example', -style=>'payment.css' ),
	$page->h3( 'Smart Checkout - Custom Receipt' );
	
	my %receipt = $page->Vars;
	
	my @receipt_fields = ();
	foreach my $field_name( keys %receipt ) {
		my $field_value = $receipt{ $field_name };
		push( @receipt_fields, $page->div( $page->span( { -class=>'fieldName' }, "$field_name" ), $page->span( { -class=>'fieldValue' }, "$field_value" ) )."\n" );	
	}

	my $signature_was_valid = "False";
	my @signed_field_names = split(',', $receipt{ 'signed_field_names' } );
	$signature_was_valid = "True" if ( $receipt{ 'signature' } eq &sign( \%receipt, \@signed_field_names ) );
	push( @receipt_fields, $page->div( $page->span( { -class=>'fieldName' }, "Signature Verified" ), $page->span( { -class=>'fieldValue' }, "$signature_was_valid" ) )."\n" );

print   $page->fieldset( $page->legend( 'Receipt Details' ), $page->div( @receipt_fields ) );	
print   $page->end_html;
